package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TeacupWithoutHandle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🍵",
        description = "teacup without handle",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("teacup-without-handle", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: drink: teacup without handle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TeacupWithoutHandle: Emoji get() = _TeacupWithoutHandle
