package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TumblerGlass: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥃",
        description = "tumbler glass",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("tumbler-glass", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: drink: tumbler glass.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TumblerGlass: Emoji get() = _TumblerGlass
