package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Backpack: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎒",
        description = "backpack",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("backpack", "school-backpack"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: clothing: backpack.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Backpack: Emoji get() = _Backpack

/**
 * Alias to emoji [Backpack] (Objects: clothing: backpack).
*/
public val Emoji.Companion.SchoolBackpack: Emoji get() = _Backpack
