package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TriangularRuler: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📐",
        description = "triangular ruler",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("triangular-ruler", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: office: triangular ruler.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TriangularRuler: Emoji get() = _TriangularRuler
