package org.kodein.emoji.objects.sound

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllSound() {
    add(intArrayOf(0x1f507), _MutedSpeaker)
    add(intArrayOf(0x1f508), _SpeakerLowVolume)
    add(intArrayOf(0x1f509), _SpeakerMediumVolume)
    add(intArrayOf(0x1f50a), _SpeakerHighVolume)
    add(intArrayOf(0x1f4e2), _Loudspeaker)
    add(intArrayOf(0x1f4e3), _Megaphone)
    add(intArrayOf(0x1f4ef), _PostalHorn)
    add(intArrayOf(0x1f514), _Bell)
    add(intArrayOf(0x1f515), _BellWithSlash)
}

internal suspend fun SequenceScope<Emoji>.yieldAllSound() {
    yield(_MutedSpeaker)
    yield(_SpeakerLowVolume)
    yield(_SpeakerMediumVolume)
    yield(_SpeakerHighVolume)
    yield(_Loudspeaker)
    yield(_Megaphone)
    yield(_PostalHorn)
    yield(_Bell)
    yield(_BellWithSlash)
}

internal val countSound = 9

/**
 * All Emoji of the Objects: sound subgroup.
*/
public fun Emoji.Companion.sequenceSound(): Sequence<Emoji> =
    sequence { yieldAllSound() }

/**
 * All Emoji of the Objects: sound subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listSound(): List<Emoji> =
    ArrayList<Emoji>(countSound).also { list -> sequenceSound().forEach { list.add(it) } }

@Deprecated("Renamed listSound.", replaceWith = ReplaceWith("listSound()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allSound(): List<Emoji> =
    listSound()
