package org.kodein.emoji.people_body.body_parts

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MechanicalArm: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🦾",
        description = "mechanical arm",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("mechanical-arm", "arm-mechanical"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji People & Body: body-parts: mechanical arm.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MechanicalArm: Emoji get() = _MechanicalArm

/**
 * Alias to emoji [MechanicalArm] (People & Body: body-parts: mechanical arm).
*/
public val Emoji.Companion.ArmMechanical: Emoji get() = _MechanicalArm
