package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _CoupleWithHeartWomanMan: SkinTone2Emoji = SkinTone2EmojiImpl(
    details = Emoji.Details(
        string = "👩‍❤️‍👨",
        description = "couple with heart: woman, man",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("couple-with-heart-woman-man", "heart-with-woman-and-man"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk21c = 2,
    sk22c = 8,
)

/**
 * Emoji People & Body: family: couple with heart: woman, man.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CoupleWithHeartWomanMan: SkinTone2Emoji get() = _CoupleWithHeartWomanMan

/**
 * Alias to emoji [CoupleWithHeartWomanMan] (People & Body: family: couple with heart: woman, man).
*/
public val Emoji.Companion.HeartWithWomanAndMan: SkinTone2Emoji get() = _CoupleWithHeartWomanMan
