package org.kodein.emoji.people_body.hand_fingers_partial

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _OkHand: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "👌",
        description = "OK hand",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("ok-hand", "ok"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-fingers-partial: OK hand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OkHand: SkinTone1Emoji get() = _OkHand

/**
 * Alias to emoji [OkHand] (People & Body: hand-fingers-partial: OK hand).
*/
public val Emoji.Companion.Ok: SkinTone1Emoji get() = _OkHand
