package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonGettingMassage: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "💆",
        description = "person getting massage",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-getting-massage", "massage"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-activity: person getting massage.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonGettingMassage: SkinTone1Emoji get() = _PersonGettingMassage

/**
 * Alias to emoji [PersonGettingMassage] (People & Body: person-activity: person getting massage).
*/
public val Emoji.Companion.Massage: SkinTone1Emoji get() = _PersonGettingMassage
