package org.kodein.emoji.people_body.person_role

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonWithSkullcap: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "👲",
        description = "person with skullcap",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-with-skullcap", "gua-pi-mao"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-role: person with skullcap.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonWithSkullcap: SkinTone1Emoji get() = _PersonWithSkullcap

/**
 * Alias to emoji [PersonWithSkullcap] (People & Body: person-role: person with skullcap).
*/
public val Emoji.Companion.GuaPiMao: SkinTone1Emoji get() = _PersonWithSkullcap
