package org.kodein.emoji.smileys_emotion.emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _KissMark: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💋",
        description = "kiss mark",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("kiss-mark", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: emotion: kiss mark.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.KissMark: Emoji get() = _KissMark
