package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceHoldingBackTears: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥹",
        description = "face holding back tears",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("face-holding-back-tears", "holding-back-tears"),
        emoticons = listOf("(；人；)"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: face holding back tears.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceHoldingBackTears: Emoji get() = _FaceHoldingBackTears

/**
 * Alias to emoji [FaceHoldingBackTears] (Smileys & Emotion: face-concerned: face holding back tears).
*/
public val Emoji.Companion.HoldingBackTears: Emoji get() = _FaceHoldingBackTears
