package org.kodein.emoji.smileys_emotion.face_smiling

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmilingFaceWithSmilingEyes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😊",
        description = "smiling face with smiling eyes",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("smiling-face-with-smiling-eyes", "blush"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-smiling: smiling face with smiling eyes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmilingFaceWithSmilingEyes: Emoji get() = _SmilingFaceWithSmilingEyes

/**
 * Alias to emoji [SmilingFaceWithSmilingEyes] (Smileys & Emotion: face-smiling: smiling face with smiling eyes).
*/
public val Emoji.Companion.Blush: Emoji get() = _SmilingFaceWithSmilingEyes
