package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RepeatSingleButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔂",
        description = "repeat single button",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("repeat-single-button", "repeat-one"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: repeat single button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RepeatSingleButton: Emoji get() = _RepeatSingleButton

/**
 * Alias to emoji [RepeatSingleButton] (Symbols: av-symbol: repeat single button).
*/
public val Emoji.Companion.RepeatOne: Emoji get() = _RepeatSingleButton
