package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PurpleSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🟪",
        description = "purple square",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("purple-square", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: purple square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PurpleSquare: Emoji get() = _PurpleSquare
