package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _KeycapStar: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "*️⃣",
        description = "keycap: *",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("keycap-", "asterisk", "keycap-asterisk"),
        emoticons = listOf(),
        notoImageRatio = 0.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: keycap: keycap: *.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.KeycapStar: Emoji get() = _KeycapStar

/**
 * Alias to emoji [KeycapStar] (Symbols: keycap: keycap: *).
*/
public val Emoji.Companion.Asterisk: Emoji get() = _KeycapStar

/**
 * Alias to emoji [KeycapStar] (Symbols: keycap: keycap: *).
*/
public val Emoji.Companion.KeycapAsterisk: Emoji get() = _KeycapStar
