package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CheckMark: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "✔️",
        description = "check mark",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("check-mark", "check-mark-black"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: other-symbol: check mark.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CheckMark: Emoji get() = _CheckMark

/**
 * Alias to emoji [CheckMark] (Symbols: other-symbol: check mark).
*/
public val Emoji.Companion.CheckMarkBlack: Emoji get() = _CheckMark
