package org.kodein.emoji.symbols.religion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PlaceOfWorship: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🛐",
        description = "place of worship",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("place-of-worship", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: religion: place of worship.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PlaceOfWorship: Emoji get() = _PlaceOfWorship
