package org.kodein.emoji.travel_places.place_map

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GlobeShowingAmericas: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌎",
        description = "globe showing Americas",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("globe-showing-americas", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-map: globe showing Americas.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GlobeShowingAmericas: Emoji get() = _GlobeShowingAmericas
