package org.kodein.emoji.travel_places.place_map

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WorldMap: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🗺️",
        description = "world map",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("world-map", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-map: world map.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WorldMap: Emoji get() = _WorldMap
