package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllSkyWeather() {
    add(intArrayOf(0x1f311), _NewMoon)
    add(intArrayOf(0x1f312), _WaxingCrescentMoon)
    add(intArrayOf(0x1f313), _FirstQuarterMoon)
    add(intArrayOf(0x1f314), _WaxingGibbousMoon)
    add(intArrayOf(0x1f315), _FullMoon)
    add(intArrayOf(0x1f316), _WaningGibbousMoon)
    add(intArrayOf(0x1f317), _LastQuarterMoon)
    add(intArrayOf(0x1f318), _WaningCrescentMoon)
    add(intArrayOf(0x1f319), _CrescentMoon)
    add(intArrayOf(0x1f31a), _NewMoonFace)
    add(intArrayOf(0x1f31b), _FirstQuarterMoonFace)
    add(intArrayOf(0x1f31c), _LastQuarterMoonFace)
    add(intArrayOf(0x1f321, 0xfe0f), _Thermometer)
    add(intArrayOf(0x1f321), _Thermometer)
    add(intArrayOf(0x2600, 0xfe0f), _Sun)
    add(intArrayOf(0x2600), _Sun)
    add(intArrayOf(0x1f31d), _FullMoonFace)
    add(intArrayOf(0x1f31e), _SunWithFace)
    add(intArrayOf(0x1fa90), _RingedPlanet)
    add(intArrayOf(0x2b50), _Star)
    add(intArrayOf(0x1f31f), _GlowingStar)
    add(intArrayOf(0x1f320), _ShootingStar)
    add(intArrayOf(0x1f30c), _MilkyWay)
    add(intArrayOf(0x2601, 0xfe0f), _Cloud)
    add(intArrayOf(0x2601), _Cloud)
    add(intArrayOf(0x26c5), _SunBehindCloud)
    add(intArrayOf(0x26c8, 0xfe0f), _CloudWithLightningAndRain)
    add(intArrayOf(0x26c8), _CloudWithLightningAndRain)
    add(intArrayOf(0x1f324, 0xfe0f), _SunBehindSmallCloud)
    add(intArrayOf(0x1f324), _SunBehindSmallCloud)
    add(intArrayOf(0x1f325, 0xfe0f), _SunBehindLargeCloud)
    add(intArrayOf(0x1f325), _SunBehindLargeCloud)
    add(intArrayOf(0x1f326, 0xfe0f), _SunBehindRainCloud)
    add(intArrayOf(0x1f326), _SunBehindRainCloud)
    add(intArrayOf(0x1f327, 0xfe0f), _CloudWithRain)
    add(intArrayOf(0x1f327), _CloudWithRain)
    add(intArrayOf(0x1f328, 0xfe0f), _CloudWithSnow)
    add(intArrayOf(0x1f328), _CloudWithSnow)
    add(intArrayOf(0x1f329, 0xfe0f), _CloudWithLightning)
    add(intArrayOf(0x1f329), _CloudWithLightning)
    add(intArrayOf(0x1f32a, 0xfe0f), _Tornado)
    add(intArrayOf(0x1f32a), _Tornado)
    add(intArrayOf(0x1f32b, 0xfe0f), _Fog)
    add(intArrayOf(0x1f32b), _Fog)
    add(intArrayOf(0x1f32c, 0xfe0f), _WindFace)
    add(intArrayOf(0x1f32c), _WindFace)
    add(intArrayOf(0x1f300), _Cyclone)
    add(intArrayOf(0x1f308), _Rainbow)
    add(intArrayOf(0x1f302), _ClosedUmbrella)
    add(intArrayOf(0x2602, 0xfe0f), _Umbrella)
    add(intArrayOf(0x2602), _Umbrella)
    add(intArrayOf(0x2614), _UmbrellaWithRainDrops)
    add(intArrayOf(0x26f1, 0xfe0f), _UmbrellaOnGround)
    add(intArrayOf(0x26f1), _UmbrellaOnGround)
    add(intArrayOf(0x26a1), _HighVoltage)
    add(intArrayOf(0x2744, 0xfe0f), _Snowflake)
    add(intArrayOf(0x2744), _Snowflake)
    add(intArrayOf(0x2603, 0xfe0f), _Snowman)
    add(intArrayOf(0x2603), _Snowman)
    add(intArrayOf(0x26c4), _SnowmanWithoutSnow)
    add(intArrayOf(0x2604, 0xfe0f), _Comet)
    add(intArrayOf(0x2604), _Comet)
    add(intArrayOf(0x1f525), _Fire)
    add(intArrayOf(0x1f4a7), _Droplet)
    add(intArrayOf(0x1f30a), _WaterWave)
}

internal suspend fun SequenceScope<Emoji>.yieldAllSkyWeather() {
    yield(_NewMoon)
    yield(_WaxingCrescentMoon)
    yield(_FirstQuarterMoon)
    yield(_WaxingGibbousMoon)
    yield(_FullMoon)
    yield(_WaningGibbousMoon)
    yield(_LastQuarterMoon)
    yield(_WaningCrescentMoon)
    yield(_CrescentMoon)
    yield(_NewMoonFace)
    yield(_FirstQuarterMoonFace)
    yield(_LastQuarterMoonFace)
    yield(_Thermometer)
    yield(_Sun)
    yield(_FullMoonFace)
    yield(_SunWithFace)
    yield(_RingedPlanet)
    yield(_Star)
    yield(_GlowingStar)
    yield(_ShootingStar)
    yield(_MilkyWay)
    yield(_Cloud)
    yield(_SunBehindCloud)
    yield(_CloudWithLightningAndRain)
    yield(_SunBehindSmallCloud)
    yield(_SunBehindLargeCloud)
    yield(_SunBehindRainCloud)
    yield(_CloudWithRain)
    yield(_CloudWithSnow)
    yield(_CloudWithLightning)
    yield(_Tornado)
    yield(_Fog)
    yield(_WindFace)
    yield(_Cyclone)
    yield(_Rainbow)
    yield(_ClosedUmbrella)
    yield(_Umbrella)
    yield(_UmbrellaWithRainDrops)
    yield(_UmbrellaOnGround)
    yield(_HighVoltage)
    yield(_Snowflake)
    yield(_Snowman)
    yield(_SnowmanWithoutSnow)
    yield(_Comet)
    yield(_Fire)
    yield(_Droplet)
    yield(_WaterWave)
}

internal val countSkyWeather = 47

/**
 * All Emoji of the Travel & Places: sky & weather subgroup.
*/
public fun Emoji.Companion.sequenceSkyWeather(): Sequence<Emoji> =
    sequence { yieldAllSkyWeather() }

/**
 * All Emoji of the Travel & Places: sky & weather subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listSkyWeather(): List<Emoji> =
    ArrayList<Emoji>(countSkyWeather).also { list -> sequenceSkyWeather().forEach { list.add(it) } }

@Deprecated("Renamed listSkyWeather.", replaceWith = ReplaceWith("listSkyWeather()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allSkyWeather(): List<Emoji> =
    listSkyWeather()
