package org.kodein.emoji.animals_nature.plant_other

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPlantOther() {
    add(intArrayOf(0x1f331), _Seedling)
    add(intArrayOf(0x1fab4), _PottedPlant)
    add(intArrayOf(0x1f332), _EvergreenTree)
    add(intArrayOf(0x1f333), _DeciduousTree)
    add(intArrayOf(0x1f334), _PalmTree)
    add(intArrayOf(0x1f335), _Cactus)
    add(intArrayOf(0x1f33e), _SheafOfRice)
    add(intArrayOf(0x1f33f), _Herb)
    add(intArrayOf(0x2618, 0xfe0f), _Shamrock)
    add(intArrayOf(0x2618), _Shamrock)
    add(intArrayOf(0x1f340), _FourLeafClover)
    add(intArrayOf(0x1f341), _MapleLeaf)
    add(intArrayOf(0x1f342), _FallenLeaf)
    add(intArrayOf(0x1f343), _LeafFlutteringInWind)
    add(intArrayOf(0x1fab9), _EmptyNest)
    add(intArrayOf(0x1faba), _NestWithEggs)
    add(intArrayOf(0x1f344), _Mushroom)
}

internal suspend fun SequenceScope<Emoji>.yieldAllPlantOther() {
    yield(_Seedling)
    yield(_PottedPlant)
    yield(_EvergreenTree)
    yield(_DeciduousTree)
    yield(_PalmTree)
    yield(_Cactus)
    yield(_SheafOfRice)
    yield(_Herb)
    yield(_Shamrock)
    yield(_FourLeafClover)
    yield(_MapleLeaf)
    yield(_FallenLeaf)
    yield(_LeafFlutteringInWind)
    yield(_EmptyNest)
    yield(_NestWithEggs)
    yield(_Mushroom)
}

internal val countPlantOther = 16

/**
 * All Emoji of the Animals & Nature: plant-other subgroup.
*/
public fun Emoji.Companion.sequencePlantOther(): Sequence<Emoji> =
    sequence { yieldAllPlantOther() }

/**
 * All Emoji of the Animals & Nature: plant-other subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listPlantOther(): List<Emoji> =
    ArrayList<Emoji>(countPlantOther).also { list -> sequencePlantOther().forEach { list.add(it) } }

@Deprecated("Renamed listPlantOther.", replaceWith = ReplaceWith("listPlantOther()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allPlantOther(): List<Emoji> =
    listPlantOther()
