package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagArgentina: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇷",
        description = "flag: Argentina",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-argentina", "argentina-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.6f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Argentina.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagArgentina: Emoji get() = _FlagArgentina

/**
 * Alias to emoji [FlagArgentina] (Flags: country-flag: flag: Argentina).
*/
public val Emoji.Companion.ArgentinaFlag: Emoji get() = _FlagArgentina
