package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagEthiopia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇪🇹",
        description = "flag: Ethiopia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-ethiopia", "ethiopia-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Ethiopia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagEthiopia: Emoji get() = _FlagEthiopia

/**
 * Alias to emoji [FlagEthiopia] (Flags: country-flag: flag: Ethiopia).
*/
public val Emoji.Companion.EthiopiaFlag: Emoji get() = _FlagEthiopia
