package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagKazakhstan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇰🇿",
        description = "flag: Kazakhstan",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-kazakhstan", "kazakhstan-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Kazakhstan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagKazakhstan: Emoji get() = _FlagKazakhstan

/**
 * Alias to emoji [FlagKazakhstan] (Flags: country-flag: flag: Kazakhstan).
*/
public val Emoji.Companion.KazakhstanFlag: Emoji get() = _FlagKazakhstan
