package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMalta: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇹",
        description = "flag: Malta",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-malta", "malta-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Malta.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMalta: Emoji get() = _FlagMalta

/**
 * Alias to emoji [FlagMalta] (Flags: country-flag: flag: Malta).
*/
public val Emoji.Companion.MaltaFlag: Emoji get() = _FlagMalta
