package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSenegal: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇳",
        description = "flag: Senegal",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-senegal", "senegal-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Senegal.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSenegal: Emoji get() = _FlagSenegal

/**
 * Alias to emoji [FlagSenegal] (Flags: country-flag: flag: Senegal).
*/
public val Emoji.Companion.SenegalFlag: Emoji get() = _FlagSenegal
