package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WineGlass: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🍷",
        description = "wine glass",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("wine-glass", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Food & Drink: drink: wine glass.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WineGlass: Emoji get() = _WineGlass
