package org.kodein.emoji.food_drink.food_sweet

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFoodSweet() {
    add(intArrayOf(0x1f366), _SoftIceCream)
    add(intArrayOf(0x1f367), _ShavedIce)
    add(intArrayOf(0x1f368), _IceCream)
    add(intArrayOf(0x1f369), _Doughnut)
    add(intArrayOf(0x1f36a), _Cookie)
    add(intArrayOf(0x1f382), _BirthdayCake)
    add(intArrayOf(0x1f370), _Shortcake)
    add(intArrayOf(0x1f9c1), _Cupcake)
    add(intArrayOf(0x1f967), _Pie)
    add(intArrayOf(0x1f36b), _ChocolateBar)
    add(intArrayOf(0x1f36c), _Candy)
    add(intArrayOf(0x1f36d), _Lollipop)
    add(intArrayOf(0x1f36e), _Custard)
    add(intArrayOf(0x1f36f), _HoneyPot)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFoodSweet() {
    yield(_SoftIceCream)
    yield(_ShavedIce)
    yield(_IceCream)
    yield(_Doughnut)
    yield(_Cookie)
    yield(_BirthdayCake)
    yield(_Shortcake)
    yield(_Cupcake)
    yield(_Pie)
    yield(_ChocolateBar)
    yield(_Candy)
    yield(_Lollipop)
    yield(_Custard)
    yield(_HoneyPot)
}

internal val countFoodSweet = 14

/**
 * All Emoji of the Food & Drink: food-sweet subgroup.
*/
public fun Emoji.Companion.sequenceFoodSweet(): Sequence<Emoji> =
    sequence { yieldAllFoodSweet() }

/**
 * All Emoji of the Food & Drink: food-sweet subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFoodSweet(): List<Emoji> =
    ArrayList<Emoji>(countFoodSweet).also { list -> sequenceFoodSweet().forEach { list.add(it) } }

@Deprecated("Renamed listFoodSweet.", replaceWith = ReplaceWith("listFoodSweet()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFoodSweet(): List<Emoji> =
    listFoodSweet()
