package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OnePieceSwimsuit: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🩱",
        description = "one-piece swimsuit",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("one-piece-swimsuit", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: clothing: one-piece swimsuit.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OnePieceSwimsuit: Emoji get() = _OnePieceSwimsuit
