package org.kodein.emoji.objects.lock

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllLock() {
    add(intArrayOf(0x1f512), _Locked)
    add(intArrayOf(0x1f513), _Unlocked)
    add(intArrayOf(0x1f50f), _LockedWithPen)
    add(intArrayOf(0x1f510), _LockedWithKey)
    add(intArrayOf(0x1f511), _Key)
    add(intArrayOf(0x1f5dd, 0xfe0f), _OldKey)
    add(intArrayOf(0x1f5dd), _OldKey)
}

internal suspend fun SequenceScope<Emoji>.yieldAllLock() {
    yield(_Locked)
    yield(_Unlocked)
    yield(_LockedWithPen)
    yield(_LockedWithKey)
    yield(_Key)
    yield(_OldKey)
}

internal val countLock = 6

/**
 * All Emoji of the Objects: lock subgroup.
*/
public fun Emoji.Companion.sequenceLock(): Sequence<Emoji> =
    sequence { yieldAllLock() }

/**
 * All Emoji of the Objects: lock subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listLock(): List<Emoji> =
    ArrayList<Emoji>(countLock).also { list -> sequenceLock().forEach { list.add(it) } }

@Deprecated("Renamed listLock.", replaceWith = ReplaceWith("listLock()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allLock(): List<Emoji> =
    listLock()
