package org.kodein.emoji.objects.mail

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ClosedMailboxWithRaisedFlag: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📫",
        description = "closed mailbox with raised flag",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("closed-mailbox-with-raised-flag", "closed-mailbox-with-raised"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: mail: closed mailbox with raised flag.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ClosedMailboxWithRaisedFlag: Emoji get() = _ClosedMailboxWithRaisedFlag

/**
 * Alias to emoji [ClosedMailboxWithRaisedFlag] (Objects: mail: closed mailbox with raised flag).
*/
public val Emoji.Companion.ClosedMailboxWithRaised: Emoji get() = _ClosedMailboxWithRaisedFlag
