package org.kodein.emoji.objects.mail

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _EMail: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📧",
        description = "e-mail",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("e-mail", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: mail: e-mail.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.EMail: Emoji get() = _EMail
