package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OpenFileFolder: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📂",
        description = "open file folder",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("open-file-folder", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: office: open file folder.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OpenFileFolder: Emoji get() = _OpenFileFolder
