package org.kodein.emoji.objects.phone

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MobilePhone: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📱",
        description = "mobile phone",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("mobile-phone", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: phone: mobile phone.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MobilePhone: Emoji get() = _MobilePhone
