package org.kodein.emoji.objects.science

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TestTube: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧪",
        description = "test tube",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("test-tube", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: science: test tube.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TestTube: Emoji get() = _TestTube
