package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FamilyManManGirl: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👨‍👨‍👧",
        description = "family: man, man, girl",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("family-man-man-girl", ),
        emoticons = listOf(),
        notoImageRatio = 0.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji People & Body: family: family: man, man, girl.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FamilyManManGirl: Emoji get() = _FamilyManManGirl
