package org.kodein.emoji.people_body.family

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone2Emoji
import org.kodein.emoji.SkinTone2EmojiZWJImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _WomenHoldingHands: SkinTone2Emoji = SkinTone2EmojiZWJImpl(
    details = Emoji.Details(
        string = "👭",
        description = "women holding hands",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("women-holding-hands", "holding-hands-women"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
    zwjTemplate = "👩‍🤝‍👩",
    zwjUnicodeVersion = UnicodeVersion(12, 1),
    sk21c = 2,
    sk22c = 8,
)

/**
 * Emoji People & Body: family: women holding hands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WomenHoldingHands: SkinTone2Emoji get() = _WomenHoldingHands

/**
 * Alias to emoji [WomenHoldingHands] (People & Body: family: women holding hands).
*/
public val Emoji.Companion.HoldingHandsWomen: SkinTone2Emoji get() = _WomenHoldingHands
