package org.kodein.emoji.people_body.hand_fingers_open

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _RightwardsPushingHand: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🫸",
        description = "rightwards pushing hand",
        unicodeVersion = UnicodeVersion(15, 0),
        aliases = listOf("rightwards-pushing-hand", "push-rightwards"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-fingers-open: rightwards pushing hand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RightwardsPushingHand: SkinTone1Emoji get() = _RightwardsPushingHand

/**
 * Alias to emoji [RightwardsPushingHand] (People & Body: hand-fingers-open: rightwards pushing hand).
*/
public val Emoji.Companion.PushRightwards: SkinTone1Emoji get() = _RightwardsPushingHand
