package org.kodein.emoji.people_body.person

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _Person: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧑",
        description = "person",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("person", "adult"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person: person.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Person: SkinTone1Emoji get() = _Person

/**
 * Alias to emoji [Person] (People & Body: person: person).
*/
public val Emoji.Companion.Adult: SkinTone1Emoji get() = _Person
