package org.kodein.emoji.smileys_emotion.emotion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HundredPoints: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💯",
        description = "hundred points",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("hundred-points", "100", "one-hundred", "hundred", "points"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: emotion: hundred points.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HundredPoints: Emoji get() = _HundredPoints

/**
 * Alias to emoji [HundredPoints] (Smileys & Emotion: emotion: hundred points).
*/
public val Emoji.Companion.OneHundred: Emoji get() = _HundredPoints

/**
 * Alias to emoji [HundredPoints] (Smileys & Emotion: emotion: hundred points).
*/
public val Emoji.Companion.Hundred: Emoji get() = _HundredPoints

/**
 * Alias to emoji [HundredPoints] (Smileys & Emotion: emotion: hundred points).
*/
public val Emoji.Companion.Points: Emoji get() = _HundredPoints
