package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlushedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😳",
        description = "flushed face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flushed-face", "flushed"),
        emoticons = listOf("8‑0"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: flushed face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlushedFace: Emoji get() = _FlushedFace

/**
 * Alias to emoji [FlushedFace] (Smileys & Emotion: face-concerned: flushed face).
*/
public val Emoji.Companion.Flushed: Emoji get() = _FlushedFace
