package org.kodein.emoji.smileys_emotion.face_negative

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AngryFaceWithHorns: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👿",
        description = "angry face with horns",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("angry-face-with-horns", "imp-frown"),
        emoticons = listOf("3:("),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-negative: angry face with horns.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AngryFaceWithHorns: Emoji get() = _AngryFaceWithHorns

/**
 * Alias to emoji [AngryFaceWithHorns] (Smileys & Emotion: face-negative: angry face with horns).
*/
public val Emoji.Companion.ImpFrown: Emoji get() = _AngryFaceWithHorns
