package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AButtonBloodType: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🅰️",
        description = "A button (blood type)",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("a-button-blood-type-", "a-button", "blood-type-a"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: A button (blood type).
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AButtonBloodType: Emoji get() = _AButtonBloodType

/**
 * Alias to emoji [AButtonBloodType] (Symbols: alphanum: A button (blood type)).
*/
public val Emoji.Companion.AButton: Emoji get() = _AButtonBloodType

/**
 * Alias to emoji [AButtonBloodType] (Symbols: alphanum: A button (blood type)).
*/
public val Emoji.Companion.BloodTypeA: Emoji get() = _AButtonBloodType
