package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _UpLeftArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "↖️",
        description = "up-left arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("up-left-arrow", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: arrow: up-left arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.UpLeftArrow: Emoji get() = _UpLeftArrow
