package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NextTrackButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⏭️",
        description = "next track button",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("next-track-button", "next-track", "play-next", "next", "right-pointing-double-triangle-with-vertical-bar"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: next track button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NextTrackButton: Emoji get() = _NextTrackButton

/**
 * Alias to emoji [NextTrackButton] (Symbols: av-symbol: next track button).
*/
public val Emoji.Companion.NextTrack: Emoji get() = _NextTrackButton

/**
 * Alias to emoji [NextTrackButton] (Symbols: av-symbol: next track button).
*/
public val Emoji.Companion.PlayNext: Emoji get() = _NextTrackButton

/**
 * Alias to emoji [NextTrackButton] (Symbols: av-symbol: next track button).
*/
public val Emoji.Companion.Next: Emoji get() = _NextTrackButton

/**
 * Alias to emoji [NextTrackButton] (Symbols: av-symbol: next track button).
*/
public val Emoji.Companion.RightPointingDoubleTriangleWithVerticalBar: Emoji get() = _NextTrackButton
