package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BrownSquare: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🟫",
        description = "brown square",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("brown-square", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: brown square.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BrownSquare: Emoji get() = _BrownSquare
