package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CrossMark: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "❌",
        description = "cross mark",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("cross-mark", "x"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: other-symbol: cross mark.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CrossMark: Emoji get() = _CrossMark

/**
 * Alias to emoji [CrossMark] (Symbols: other-symbol: cross mark).
*/
public val Emoji.Companion.X: Emoji get() = _CrossMark
