package org.kodein.emoji.symbols.religion

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AtomSymbol: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⚛️",
        description = "atom symbol",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("atom-symbol", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: religion: atom symbol.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AtomSymbol: Emoji get() = _AtomSymbol
