package org.kodein.emoji.symbols.transport_sign

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WaterCloset: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚾",
        description = "water closet",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("water-closet", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: transport-sign: water closet.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WaterCloset: Emoji get() = _WaterCloset
